/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.design.property.dialog;

import filenet.vw.api.VWMapDefinition;
import filenet.vw.api.VWMapNode;
import filenet.vw.api.VWMilestoneDefinition;
import filenet.vw.api.VWStepDefinition;
import filenet.vw.api.VWWorkflowDefinition;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.design.property.VWAuthPropertyData;
import filenet.vw.toolkit.design.property.resources.VWResource;
import filenet.vw.toolkit.design.property.tables.VWMilestoneUsageItem;
import filenet.vw.toolkit.design.property.tables.VWMilestoneUsageListCellRenderer;
import filenet.vw.toolkit.utils.VWHelp;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.dialog.VWDialogButtons;
import filenet.vw.toolkit.utils.dialog.VWModalDialog;
import filenet.vw.toolkit.utils.event.IVWDialogButtonsActionListener;
import filenet.vw.toolkit.utils.event.VWDialogButtonsActionEvent;
import filenet.vw.toolkit.utils.table.VWLabelListCellRenderer;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorder;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultListModel;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class VWMilestoneUsageDialog
extends VWModalDialog
implements ActionListener,
IVWDialogButtonsActionListener {
    private VWToolbarBorder m_milestoneBorder = null;
    private JComboBox m_milestoneComboBox = null;
    private VWToolbarBorder m_submapBorder = null;
    private JComboBox m_submapComboBox = null;
    private VWToolbarBorder m_stepsBorder = null;
    private JList m_stepsList = null;
    private VWDialogButtons m_dialogControls = null;
    private GridBagConstraints m_gbCons = null;
    private VWAuthPropertyData m_authPropertyData = null;
    private VWMilestoneDefinition m_milestoneDef = null;

    public VWMilestoneUsageDialog(Frame parentFrame, VWAuthPropertyData authPropertyData, VWMilestoneDefinition milestoneDef) {
        super(parentFrame);
        this.m_authPropertyData = authPropertyData;
        this.m_milestoneDef = milestoneDef;
    }

    public void init() {
        this.getContentPane().setLayout(new GridBagLayout());
        this.m_gbCons = new GridBagConstraints();
        this.setTitle(VWResource.s_milestoneUsage);
        Dimension dim = VWStringUtils.stringToDimension("685,445");
        if (dim != null) {
            this.setSize(dim);
        } else {
            this.setSize(new Dimension(600, 400));
        }
        this.createMilestoneControls();
        this.createSubmapControls();
        this.createStepsControls();
        this.createDialogControls();
        this.reinitialize();
    }

    public boolean hasMaps() {
        if (this.m_submapComboBox != null) {
            return this.m_submapComboBox.getModel().getSize() > 0;
        }
        return false;
    }

    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source == this.m_milestoneComboBox) {
            this.performMilestoneAction();
        } else if (source == this.m_submapComboBox) {
            this.performSubmapAction();
        }
    }

    public void dialogButtonsActionPerformed(VWDialogButtonsActionEvent event) {
        Object source = event.getSource();
        if (source == this.m_dialogControls) {
            int id = event.getID();
            switch (id) {
                case 4: {
                    this.performClose();
                    break;
                }
                case 32: {
                    this.performHelp();
                }
            }
        }
    }

    private void reinitialize() {
        try {
            if (this.m_authPropertyData != null) {
                VWMapDefinition[] mapDefs;
                int i;
                int milestoneDefCount;
                VWMilestoneDefinition[] milestoneDefs = this.m_authPropertyData.getMilestones();
                if (milestoneDefs != null && (milestoneDefCount = milestoneDefs.length) > 0) {
                    this.m_milestoneComboBox.removeActionListener(this);
                    for (i = 0; i < milestoneDefCount; ++i) {
                        this.m_milestoneComboBox.addItem(milestoneDefs[i].getName());
                    }
                    this.m_milestoneComboBox.addActionListener(this);
                }
                if ((mapDefs = this.m_authPropertyData.getMapCache().getCurrentMapDefinitions()) != null) {
                    this.m_submapComboBox.removeActionListener(this);
                    if (this.m_authPropertyData.getMapCache().get("Workflow", false) != null) {
                        this.m_submapComboBox.addItem("Workflow");
                    }
                    for (i = 0; i < mapDefs.length; ++i) {
                        if (VWStringUtils.compare(mapDefs[i].getName(), "Workflow") == 0) continue;
                        this.m_submapComboBox.addItem(mapDefs[i].getName());
                    }
                    this.m_submapComboBox.addActionListener(this);
                }
                this.m_milestoneComboBox.setSelectedItem(this.m_milestoneDef.getName());
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void createMilestoneControls() {
        this.m_gbCons.anchor = 23;
        this.m_gbCons.fill = 2;
        this.m_gbCons.gridx = 0;
        this.m_gbCons.gridy = 0;
        this.m_gbCons.gridheight = 1;
        this.m_gbCons.gridwidth = 1;
        this.m_gbCons.weightx = 1.0;
        this.m_gbCons.weighty = 0.0;
        this.m_gbCons.insets = new Insets(3, 3, 0, 3);
        this.m_milestoneBorder = new VWToolbarBorder(VWResource.s_milestoneStr);
        this.getContentPane().add((Component)this.m_milestoneBorder, this.m_gbCons);
        JPanel milestonePanel = this.m_milestoneBorder.getClientPanel();
        milestonePanel.setLayout(new GridLayout());
        this.m_milestoneComboBox = new JComboBox();
        this.m_milestoneComboBox.addActionListener(this);
        this.m_milestoneComboBox.setRenderer(new VWLabelListCellRenderer());
        milestonePanel.add(this.m_milestoneComboBox);
    }

    private void createSubmapControls() {
        this.m_gbCons.anchor = 23;
        this.m_gbCons.fill = 2;
        this.m_gbCons.gridx = 0;
        this.m_gbCons.gridy = 1;
        this.m_gbCons.gridheight = 1;
        this.m_gbCons.gridwidth = 1;
        this.m_gbCons.weightx = 1.0;
        this.m_gbCons.weighty = 0.0;
        this.m_gbCons.insets = new Insets(0, 3, 0, 3);
        this.m_submapBorder = new VWToolbarBorder(VWResource.s_submap);
        this.getContentPane().add((Component)this.m_submapBorder, this.m_gbCons);
        JPanel submapPanel = this.m_submapBorder.getClientPanel();
        submapPanel.setLayout(new GridLayout());
        this.m_submapComboBox = new JComboBox();
        this.m_submapComboBox.addActionListener(this);
        this.m_submapComboBox.setRenderer(new VWLabelListCellRenderer());
        submapPanel.add(this.m_submapComboBox);
    }

    private void createStepsControls() {
        this.m_gbCons.anchor = 23;
        this.m_gbCons.fill = 1;
        this.m_gbCons.gridx = 0;
        this.m_gbCons.gridy = 2;
        this.m_gbCons.gridheight = 1;
        this.m_gbCons.gridwidth = 1;
        this.m_gbCons.weightx = 1.0;
        this.m_gbCons.weighty = 1.0;
        this.m_gbCons.insets = new Insets(0, 3, 0, 3);
        this.m_stepsBorder = new VWToolbarBorder(VWResource.s_stepsStr);
        this.getContentPane().add((Component)this.m_stepsBorder, this.m_gbCons);
        JPanel stepsPanel = this.m_stepsBorder.getClientPanel();
        stepsPanel.setLayout(new GridLayout());
        this.m_stepsList = new JList();
        this.m_stepsList.setCellRenderer(new VWMilestoneUsageListCellRenderer());
        this.m_stepsList.setModel(new DefaultListModel());
        stepsPanel.add(new JScrollPane(this.m_stepsList));
    }

    private void createDialogControls() {
        this.m_gbCons.anchor = 10;
        this.m_gbCons.fill = 0;
        this.m_gbCons.gridx = 0;
        this.m_gbCons.gridy = 3;
        this.m_gbCons.gridheight = 1;
        this.m_gbCons.gridwidth = 1;
        this.m_gbCons.weightx = 1.0;
        this.m_gbCons.weighty = 0.0;
        this.m_gbCons.insets = new Insets(6, 3, 3, 3);
        this.m_dialogControls = new VWDialogButtons(36);
        this.m_dialogControls.addDialogButtonsActionListener(this);
        this.getContentPane().add((Component)this.m_dialogControls, this.m_gbCons);
    }

    private void performClose() {
        this.setVisible(false);
    }

    private void performHelp() {
        VWHelp.displayPage(VWHelp.Help_Process_Designer + "bpfdh028.htm");
    }

    private void performMilestoneAction() {
        boolean isPreMilestone = false;
        boolean isPostMilestone = false;
        try {
            int mapNodeCount;
            VWMapNode[] mapNodes;
            VWMapDefinition mapDef;
            VWWorkflowDefinition wfDefinition;
            if (this.m_submapComboBox.getSelectedItem() == null) {
                return;
            }
            String currentMilestoneName = this.m_milestoneComboBox.getSelectedItem().toString();
            String submapName = this.m_submapComboBox.getSelectedItem().toString();
            DefaultListModel listModel = (DefaultListModel)this.m_stepsList.getModel();
            listModel.removeAllElements();
            if (this.m_authPropertyData != null && (wfDefinition = this.m_authPropertyData.getWorkflowDefinition()) != null && (mapDef = wfDefinition.getMap(submapName)) != null && (mapNodes = mapDef.getSteps()) != null && (mapNodeCount = mapNodes.length) > 0) {
                for (int i = 0; i < mapNodeCount; ++i) {
                    VWMapNode mapNode = mapNodes[i];
                    if (!(mapNode instanceof VWStepDefinition)) continue;
                    VWStepDefinition stepDef = (VWStepDefinition)mapNode;
                    String preMilestoneName = stepDef.getPreMilestone();
                    String postMilestoneName = stepDef.getPostMilestone();
                    isPreMilestone = preMilestoneName != null && VWStringUtils.compare(preMilestoneName, currentMilestoneName) == 0;
                    isPostMilestone = postMilestoneName != null && VWStringUtils.compare(postMilestoneName, currentMilestoneName) == 0;
                    if (!isPreMilestone && !isPostMilestone) continue;
                    VWMilestoneUsageItem item = new VWMilestoneUsageItem(stepDef.getName(), isPreMilestone, isPostMilestone);
                    listModel.addElement(item);
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void performSubmapAction() {
        this.performMilestoneAction();
    }
}

